% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getMDS.R
\name{getMDS}
\alias{getMDS}
\alias{addMDS}
\alias{addMDS,SingleCellExperiment-method}
\alias{getMDS,SingleCellExperiment-method}
\alias{getMDS,TreeSummarizedExperiment-method}
\title{Perform multi-dimensional scaling (MDS)}
\usage{
getMDS(x, ...)

addMDS(x, ...)

\S4method{addMDS}{SingleCellExperiment}(x, name = "MDS", ...)

\S4method{getMDS}{SingleCellExperiment}(x, assay.type = "counts", ...)

\S4method{getMDS}{TreeSummarizedExperiment}(x, assay.type = "counts", ...)
}
\arguments{
\item{x}{a \code{\link[SummarizedExperiment]{SummarizedExperiment}} object.}

\item{...}{additional arguments.
\itemize{
\item \code{FUN}: \code{Function}. A function that is applied to
calculate dissimilarity. (Default: \code{getDissimilarity})

\if{html}{\out{<div class="sourceCode">}}\preformatted{\\item \code{subset.result}: \code{Logical result}. Specifies whether to
subset \code{x} to match the result if some samples were removed during
calculation. (Default: \code{TRUE})
}\if{html}{\out{</div>}}

}}

\item{name}{\code{Character scalar}. A name for the \code{reducedDim()}
where results will be stored. (Default: \code{"MDS"})}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}
}
\value{
\code{getMDS} returns a MDS results.
\code{addMDS} returns a \code{x} with MDS results added to its
\code{reducedDim(x, name)}.
}
\description{
Perform multi-dimensional scaling (MDS) also know as Principal Coordinate
Analysis (PCoA). These functions are wrappers for
\code{\link[scater:runMDS]{scater::calculateMDS}}.
}
\details{
These functions are wrappers for
\code{\link[scater:runMDS]{scater::calculateMDS}} and
\code{\link[scater:runMDS]{scater::runMDS}}. While \code{getMDS}
returns the results, \code{addMDS} adds them to \code{reducedDim(x)}. The
difference is that these functions apply microbiome-specific options such
as \code{getDissimilarity} function by default.

See \code{\link[scater:runMDS]{scater::calculateMDS}} for details.
}
\examples{
library(mia)
library(scater)
library(patchwork)

data(GlobalPatterns)
tse <- GlobalPatterns

# Calculate PCoA with Bray-Curtis dissimilarity
tse <- transformAssay(tse, method = "relabundance")
tse <- addMDS(tse, assay.type = "relabundance", method = "bray")

# Calculate PCoA with Unifrac and rarefaction. (Note: increase iterations)
tse <- addMDS(tse, method = "unifrac", name = "unifrac")

# Calculate PCoA with Unifrac and rarefaction. (Note: increase iterations)
tse <- addMDS(tse, method = "unifrac", name = "unifrac_rare", niter = 2L)

# Visualize results
p1 <- plotReducedDim(tse, "unifrac", colour_by = "SampleType") +
    labs(title = "Not rarefied")
p2 <- plotReducedDim(tse, "unifrac_rare", colour_by = "SampleType") +
    labs(title = "Rarefied")
p1 + p2

}
\seealso{
\code{\link[scater:runMDS]{scater::calculateMDS}} and
\code{\link[=getDissimilarity]{getDissimilarity}}
}
