% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getStepwiseDivergence.R
\name{getStepwiseDivergence}
\alias{getStepwiseDivergence}
\alias{addStepwiseDivergence}
\alias{getStepwiseDivergence,ANY-method}
\alias{addStepwiseDivergence,SummarizedExperiment-method}
\title{Beta diversity between consecutive time steps}
\usage{
getStepwiseDivergence(x, ...)

addStepwiseDivergence(x, ...)

\S4method{getStepwiseDivergence}{ANY}(
  x,
  time.col,
  assay.type = "counts",
  time.interval = 1L,
  group = NULL,
  method = "bray",
  ...
)

\S4method{addStepwiseDivergence}{SummarizedExperiment}(
  x,
  name = c("divergence", "time_diff", "ref_samples"),
  ...
)
}
\arguments{
\item{x}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{...}{Optional arguments passed into
\code{\link[mia:addDivergence]{mia::addDivergence()}}.}

\item{time.col}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the sampling time points for the samples.}

\item{assay.type}{\code{Character scalar}. Specifies which assay values are
used in the dissimilarity estimation. (Default: \code{"counts"})}

\item{time.interval}{\code{Integer scalar}. Indicates the increment between
time steps. By default, the function compares each sample to the
previous one. If you need to take every second, every third, or so, time
step, then increase this accordingly. (Default: \code{1L})}

\item{group}{\code{Character scalar}. Specifies a name of the column from
\code{colData} that identifies the grouping of the samples.
(Default: \code{NULL})}

\item{method}{\code{Character scalar}. Used to calculate the dissimilarity
Method is passed to the function that is specified by \code{dis.fun}.
(Default: \code{"bray"})}

\item{name}{\code{Character vector}. Specifies a column name for storing
divergence results.
(Default: \code{c("divergence", "time_diff", "ref_samples")})}
}
\value{
\code{getStepwiseDivergence} returns \code{DataFrame} object
containing the sample dissimilarity and corresponding time difference between
samples. \code{addStepwiseDivergence}, on the other hand, returns a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object with these results in its \code{colData}.
}
\description{
Calculates sample dissimilarity between consecutive time points along with
time difference.
}
\details{
These functions calculate time-wise divergence, meaning each sample is
compared to the previous i-th sample, where i is the specified time
interval (see \code{time.interval}). By default, the function calculates
divergence by comparing all samples with each other. However, it is often
more meaningful to calculate divergence within a specific patient or group
(see the \code{group} parameter).
}
\examples{
library(miaTime)

data(hitchip1006)
tse <- transformAssay(hitchip1006, method = "relabundance")

# Calculate divergence
tse <- addStepwiseDivergence(
    tse,
    group = "subject",
    time.interval = 1,
    time.col = "time",
    assay.type = "relabundance"
    )

}
\seealso{
\code{\link[mia:addDivergence]{mia::addDivergence()}}
}
