% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miaTime.R
\docType{data}
\name{Kumaraswamy2024}
\alias{Kumaraswamy2024}
\title{Kumaraswamy2024}
\format{
The data set in
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
format.
}
\usage{
data(Kumaraswamy2024)
}
\value{
Loads the data set in R.
}
\description{
The Kumaraswamy2024 includes microbiota and metabolite profiling data
from 78 Indian individuals (40 males, 38 females).

The Indian subjects were grouped into four diet groups (~20 subjects per group),
and fecal samples were collected across three seasonal time points.

The microbiota profiling was performed using HITChip microarray analysis
(in duplicate), qPCR (in triplicate with eight-point standard curves), and
LC-HRMS and HPLC metabolite profiling with internal standards.

Column metadata includes diet group assignment, sampling season, sex, BMI,
age, and questionnaire-based lifestyle metadata.

Quality control metrics include Pearson correlation (>0.98) for HITChip,
qPCR assay efficiency (>0.99), and technical replicates for HPLC and qPCR.

Data sources:
\itemize{
\item Microbiota HITChip microarray data
\item qPCR absolute abundance data
\item Chemical profiling data (HPLC, LC-HRMS)
\item Sample metadata (diet, lifestyle)
}

Processed and raw data are available via:
\itemize{
\item Zenodo (DOI: https://doi.org/10.5281/zenodo.14424024)
\item NCBI-SRA (fermented foods 16S rRNA sequencing, accession: PRJNA1191989)
}
}
\references{
Jeyaram, K., Lahti, L., Tims, S. et al. Fermented foods affect the seasonal
stability of gut bacteria in an Indian rural population.
Nat Commun 16, 771 \url{https://doi.org/10.1038/s41467-025-56014-6}
}
\author{
Jeyaram, K., Lahti, L., Tims, S. et al
}
\keyword{data}
