% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomA.R
\name{randomA}
\alias{randomA}
\title{Generate random interaction matrix for GLV model}
\usage{
randomA(
  n_species,
  names_species = NULL,
  diagonal = -0.5,
  connectance = 0.2,
  scale_off_diagonal = 0.1,
  mutualism = 1,
  commensalism = 1,
  parasitism = 1,
  amensalism = 1,
  competition = 1,
  interactions = NULL,
  symmetric = FALSE,
  list_A = NULL
)
}
\arguments{
\item{n_species}{Integer: number of species}

\item{names_species}{Character: names of species. If NULL,
\code{paste0("sp", seq_len(n_species))} is used.
(default: \code{names_species = NULL})}

\item{diagonal}{\code{Numeric vector}. Defines the strength of
self-interactions. Input can be a number (will be applied to
all species) or a vector of length n_species. Positive
self-interaction values lead to exponential growth.
(Default: \code{-0.5})}

\item{connectance}{\code{Numeric scalar}. Specifies the frequency
of inter-species interactions. i.e. proportion of non-zero
off-diagonal terms. Between \code{0} and \code{1}.
(Default: \code{0.2})}

\item{scale_off_diagonal}{\code{Numeric scalar}. Indicates the
scale of the off-diagonal elements compared to the diagonal.
(Default: \code{0.1})}

\item{mutualism}{\code{Numerical scalar}. Specifies the relative
proportion of interactions terms consistent with mutualism
(positive <-> positive). (Default: \code{1})}

\item{commensalism}{\code{Numeric scalar}. Indicates the relative
proportion of interactions terms consistent with commensalism
(positive <-> neutral). (Default: \code{1})}

\item{parasitism}{\code{Numeric scalar}. Indicates the relative
proportion of interactions terms consistent with parasitism
(positive <-> negative). (Default: \code{1})}

\item{amensalism}{\code{Numeric scalar}. Indicates the relative
proportion of interactions terms consistent with amensalism
(neutral <-> negative). (Default: \code{1})}

\item{competition}{\code{Numeric scalar}. Indicates the relative
proportion of interactions terms consistent with competition
(negative <-> negative). (Default: \code{1})}

\item{interactions}{\code{Numeric scalar}. Indicates the values
of the n_species^2 pairwise interaction strengths. Diagonal terms
will be replaced by the 'diagonal' parameter. If NULL, interactions
are drawn from \code{runif(n_species^2, min=0, max=abs(diagonal))}.
Negative values are first converted to positive then the signs are defined by
the relative weights of the biological interactions (i.e. mutualism,
commensalism, parasitism, amensalism, competition).
(Default: \code{NULL})}

\item{symmetric}{\code{Logical scalar}. whether the strength of
mutualistic and competitive interactions are symmetric. This is
implemented by overwrite a half of the matrix, so the proportions
of interactions might deviate from expectations.
(Default: \code{FALSE})}

\item{list_A}{\code{List}. A list of matrices generated by randomA. Used to support
different groups of interactions. If NULL (by default), no group is
considered. Otherwise the given list of matrices will overwrite values around
the diagonal. (Default: \code{NULL})}
}
\value{
\code{randomA} returns a matrix A with dimensions (n_species x n_species)
}
\description{
Generates a random interaction matrix for Generalized Lotka-Volterra (GLV) model.
}
\examples{

dense_A <- randomA(
    n_species = 10,
    scale_off_diagonal = 1,
    diagonal = -1.0,
    connectance = 0.9
)

sparse_A <- randomA(
    n_species = 10,
    diagonal = -1.0,
    connectance = 0.09
)

user_interactions <- rbeta(n = 10^2, .5, .5)
user_A <- randomA(n_species = 10, interactions = user_interactions)

competitive_A <- randomA(
    n_species = 10,
    mutualism = 0,
    commensalism = 0,
    parasitism = 0,
    amensalism = 0,
    competition = 1,
    connectance = 1,
    scale_off_diagonal = 1
)

parasitism_A <- randomA(
    n_species = 10,
    mutualism = 0,
    commensalism = 0,
    parasitism = 1,
    amensalism = 0,
    competition = 0,
    connectance = 1,
    scale_off_diagonal = 1,
    symmetric = TRUE
)

list_A <- list(dense_A, sparse_A, competitive_A, parasitism_A)
groupA <- randomA(n_species = 40, list_A = list_A)

}
