% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbDataAccess.R
\name{translate}
\alias{translate}
\title{Homology transfer for miRNAtap}
\usage{
translate(entrezes, from = "mmu", to = "rno", ...)
}
\arguments{
\item{entrezes}{data.frame with entrez Gene IDs and their scores}

\item{from}{origin species, default \code{'mmu'}, Mus musculus}

\item{to}{target species, default}

\item{...}{any optional arguments}
}
\value{
data.frame object with orthologous genes' entrez IDs and 
corresponding scores
}
\description{
This function maps gene entrez ID between species using homology information 
from Homologene.
}
\examples{
mouse_genes <- data.frame(GeneID = 
        c("15364", "56520", "57781", "58180", "18035", "239857"))
translate(mouse_genes, from='mmu', to='rno')
}
\author{
Maciej Pajak \email{m.pajak@sms.ed.ac.uk}
}

