% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRNANameConverter.R
\docType{methods}
\name{translateMiRNAName}
\alias{translateMiRNAName}
\alias{translateMiRNAName,MiRNANameConverter,character-method}
\title{Translate miRNA name}
\usage{
translateMiRNAName(this, miRNAs, versions, sequenceFormat = 1,
  verbose = FALSE)

\S4method{translateMiRNAName}{MiRNANameConverter,character}(this, miRNAs,
  versions, sequenceFormat = 1, verbose = FALSE)
}
\arguments{
\item{this}{Object of class 'MiRNANameConverter'}

\item{miRNAs}{A character vector of miRNA names}

\item{versions}{An integer or numerical vector containing the target versions}

\item{sequenceFormat}{Integer value indicating the return format for the
data frame containing sequence information
{1=only sequences, 2=miRNA name and sequence}}

\item{verbose}{A boolean to either show more (TRUE) or less information
(FALSE)}
}
\value{
A (n x m) data frame where n is the number of valid miRNAs and m the
number of
columns (minimum 3 columns, MIMAT-ID (accession), input miRNA name, current
version)
In addition an attribute 'description' is added to the data frame where to
each miRNA some notes are added (for example why a certain miRNA is not 
in the output).
Sequence information is attached as the attribute 'sequence'.
}
\description{
This function translates input miRNA names to different 
miRBase versions.
Translate miRNA name

This function translates input miRNA names to different miRBase versions.
}
\details{
The translation and sequence retrieval are done in 5 main steps:
	1) Only take miRNA names that do not swap MIMAT IDs among versions
	(\code{\link{assessMiRNASwappingMIMAT}})
	2) Check, if the miRNA names are valid names (\code{\link{checkMiRNAName}})
	3) Receive unique MIMAT IDs for each valid miRNA
		- If there are miRNAs that have basically the same name,
		  only use miRNA names from the highest version
	4) Check if the found MIMAT IDs are still listed in the 
	    current miRBase version
		- If not, neglect it because then it is not considered to be a 
		    miRNA anymore
	5) Receive names from desired versions
}
\section{Methods (by class)}{
\itemize{
\item \code{this = MiRNANameConverter,miRNAs = character}: Method for translating miRNA name(s) to
different miRBase versions
}}

\examples{
nc = MiRNANameConverter(); # Instance of class 'MiRNANameConverter'
res = translateMiRNAName(nc, miRNAs = c("hsa-miR-140", "hsa-miR-125a"),
                   versions = c(15, 16, 20, 21))
res
attributes(res)
}
\seealso{
\code{\link{attr}} for attributes
}
\author{
Stefan Haunsberger
}
