% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRNANameConverter.R
\docType{methods}
\name{saveResults}
\alias{saveResults}
\alias{saveResults,MiRNANameConverter,data.frame-method}
\title{Save miRNA translation results}
\usage{
saveResults(this, df, outputFilename, outputPath, sep = "\\t",
  quote = FALSE, verbose = FALSE, ...)

\S4method{saveResults}{MiRNANameConverter,data.frame}(this, df, outputFilename,
  outputPath, sep = "\\t", quote = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{this}{Object of class 'MiRNANameConverter'}

\item{df}{A \code{data.frame} with translated results}

\item{outputFilename}{A filename for the output file, such as 'filename.txt'}

\item{outputPath}{A file path (character string) to the target directory}

\item{sep}{Separator}

\item{quote}{If all data values shall be surrounded by ('"')}

\item{verbose}{Boolean to either show more (TRUE) or less information (FALSE)}

\item{...}{Arguments that can be passed on to \code{write.table}}
}
\description{
This function saves the data frame returned from
translateMiRNAName inclusive the attribute 'description'.
Save miRNA translation results

This function saves the data frame returned from translateMiRNAName
inclusive the attribute 'description'.
}
\details{
This function saves a data frame that has been returned by
\code{translateMiRNAName}.
The attribute 'description' of the data frame will be stored as well.
}
\section{Methods (by class)}{
\itemize{
\item \code{this = MiRNANameConverter,df = data.frame}: Method for saving translation results
}}

\examples{
nc = MiRNANameConverter(); # Instance of class 'MiRNANameConverter'
res = translateMiRNAName(nc, miRNAs = c("hsa-miR-140", "hsa-miR-125a"),
                           versions = c(15, 16, 20, 21))
# Save translation results
saveResults(nc, res)

}
\seealso{
\code{\link{write.table}} for additional parameter values for
the '...' argument, \code{\link{attr}} for how to retrieve attributes
}
\author{
Stefan Haunsberger
}
