% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{bRank}
\alias{bRank}
\title{Extract topk predicted targets of a miRNA
Rank all the targets of a miRNA and extract the topk targets}
\usage{
bRank(CEmatrix, causeIndex, topk, downreg = TRUE)
}
\arguments{
\item{CEmatrix}{the matrix of correlation/causal effect/score results with columns are miRNAs and rows are mRNAs}

\item{causeIndex}{the column index of the miRNA that we would like to extract}

\item{topk}{the number of targets being extracted}

\item{downreg}{if TRUE the negative correlation/causal effect/score will be on the top of the ranking. This is to
favour the negative regulations.}
}
\value{
a matrix with 3 columns, where the first column contains the miRNA, the second column contains the mRNAs and the last column contains the correlations/causal effects/scores
}
\description{
Extract topk predicted targets of a miRNA
Rank all the targets of a miRNA and extract the topk targets
}
\examples{
dataset=system.file("extdata", "ToyEMT.csv", package="miRLAB")
ps=Pearson(dataset, cause=1:3, effect=4:18)
miR200aTop10 = bRank(ps, 3, 10, TRUE)
}
