% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRLAB.R
\name{DiffExpAnalysis}
\alias{DiffExpAnalysis}
\title{Differentially expressed analysis}
\usage{
DiffExpAnalysis(miR1, miR2, mR1, mR2, topkmiR, topkmR, p.miR, p.mR)
}
\arguments{
\item{miR1}{the miRNA dataset for condition 1, e.g. cancer}

\item{miR2}{the miRNA dataset for condition 1, e.g. normal}

\item{mR1}{the mRNA dataset for condition 1, e.g. cancer}

\item{mR2}{the mRNA dataset for condition 2, e.g. normal}

\item{topkmiR}{the maximum number of miRNAs that we would like to extract, e.g. top 50 miRNAs.}

\item{topkmR}{the maximum number of mRNAs that we would like to extract, e.g. top 2000 mRNAs.}

\item{p.miR}{cutoff value for adjusted p-values when conducting differentially expressed analysis for miRNAs.}

\item{p.mR}{cutoff value for adjusted p-values when conducting differentially expressed analysis for mRNAs.}
}
\value{
the dataset that includes differentially expressed miRNAs and mRNAs. columns are miRNAs and mRNAs  and rows are samples
}
\description{
Find the top miRNAs and mRNAs that are differently expression between different conditions, e.g. cancer vs normal
}
\references{
Smyth, G.K. (2005). Limma: linear models for microarray data. In Bioinformatics and computational biology solutions using R and Bioconductor (pp. 397-420). Springer New York.
}
