% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRBaseConvert.R
\name{goTo_miRBase}
\alias{goTo_miRBase}
\title{Open the miRBase webpages of the specified miRNAs}
\usage{
goTo_miRBase(Accessions)
}
\arguments{
\item{Accessions}{A character vector representing the miRNA Accessions in miRBase.
We restict the number of queried miRNAs each time. The maximum number of the input miRNAs is 15.}
}
\value{
No values
}
\description{
This function redirects the miRBase webpage of the specified miRNAs
}
\examples{
#### 1. A step-loop
Accession1="MI0000447"
goTo_miRBase(Accession1)

#### 2. A mature miRNA
Accession2="MIMAT0026477"
goTo_miRBase(Accession2)

#### 3. A list of miRNAs
Accession3=miRNATest$Accession[1:10]
goTo_miRBase(Accession3)

}
\author{
Xu, Taosheng \email{taosheng.x@gmail.com}
}
