% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRBaseConvert.R
\name{checkMiRNAAlive}
\alias{checkMiRNAAlive}
\title{Check the miRNA status(Alive or Dead)}
\usage{
checkMiRNAAlive(Accessions, verbose = TRUE)
}
\arguments{
\item{Accessions}{A character vector representing the miRNA Accessions in miRBase.}

\item{verbose}{Logical value. If true, the dead miRNAs will be printed the console.}
}
\value{
A  character vector of Accessions for all alive miRNAs. The names of the return vector are the position indexes in the input Accessions.
}
\description{
This function checks the miRNA status (Alive or Dead) in the latest miRBase version.
}
\examples{
data(miRNATest)
## The input is miRNA Accessions
Accessions=miRNATest$Accession
alive_Accession1=checkMiRNAAlive(Accessions)

##The input is miRNA names
miRNANames=miRNATest$miRNA_Name
version=checkMiRNAVersion(miRNANames,verbose = TRUE)
result=miRNA_NameToAccession(miRNANames,version = version)
Accessions=result$Accession
alive_Accession2=checkMiRNAAlive(Accessions)
}
\author{
Xu, Taosheng \email{taosheng.x@gmail.com}
}
