#' 
#' Model-based Gene Set Analysis (MGSA) is a Bayesian modeling
#' approach for gene set enrichment. The package mgsa implements MGSA and
#' tools to use MGSA together with the Gene Ontology.
#' 
#' @name mgsa-package
#' @docType package
#' @title Model-based gene set analysis
#' @author Sebastian Bauer \email{Sebastian.Bauer@@charite.de}, Julien Gagneur \email{julien.gagneur@@embl.de} 
#' @keywords package
#' @references S. Bauer, J. Gagneur and P. N. Robinson. GOing Bayesian: model-based gene set analysis of genome-scale data. Nucleic acids research, 2010.
#' @keywords package
NULL

#' This data is an example GO set for mgsa.
#'
#' @name example-go
#' @aliases example_go
#' @docType data
#' @title Example GO sets for mgsa
#' @keywords data
NULL

#' This data is an example objects for mgsa.
#'
#' @name example-o
#' @aliases example_o
#' @docType data
#' @title Example objects for mgsa
#' @keywords data
NULL
