% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfa.R
\name{summary.mfa}
\alias{summary.mfa}
\title{Summarise an mfa fit}
\usage{
\method{summary}{mfa}(object, ...)
}
\arguments{
\item{object}{An MFA fit returned by a call to \code{mfa}}

\item{...}{Additional arguments}
}
\value{
A \code{data_frame} with the following columns:
\itemize{
\item \code{pseudotime} The MAP pseudotime estimate
\item \code{branch} The MAP branch estimate
\item \code{branch_certainty} The proportion of traces for which the cell
is assigned to its MAP branch
\item \code{pseudotime_lower} The lower bound on the 95% highest-probability-density
(HPD) credible interval
\item \code{pseudotime_upper} The upper bound on the 95% HPD credible interval
}
}
\description{
Returns summary statistics of an mfa fit, including MAP pseudotime and
branch allocations along with uncertainties.
}
\examples{
synth <- create_synthetic(C = 20, G = 5)
m <- mfa(synth$X)
ms <- summary(m)
}
