% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfa.R
\name{mfa}
\alias{mfa}
\title{Fit a MFA object}
\usage{
mfa(y, iter = 2000, thin = 1, burn = iter/2, b = 2,
  zero_inflation = FALSE, pc_initialise = 1, prop_collapse = 0,
  scale_input = !zero_inflation, lambda = NULL, eta_tilde = NULL,
  alpha = 0.1, beta = 0.1, theta_tilde = 0, tau_eta = 1,
  tau_theta = 1, tau_c = 1, alpha_chi = 0.01, beta_chi = 0.01,
  w_alpha = 1/b, clamp_pseudotimes = FALSE)
}
\arguments{
\item{y}{A cell-by-gene single-cell expression matrix or an ExpressionSet object}

\item{iter}{Number of MCMC iterations}

\item{thin}{MCMC samples to thin}

\item{burn}{Number of MCMC samples to throw away}

\item{b}{Number of branches to model}

\item{zero_inflation}{Logical, should zero inflation be enabled?}

\item{pc_initialise}{Which principal component to initialise pseudotimes to}

\item{prop_collapse}{Proportion of Gibbs samples which should marginalise over c}

\item{scale_input}{Logical. If true, input is scaled to have mean 0 variance 1}

\item{lambda}{The dropout parameter - by default estimated using the function \code{empirical_lambda}}

\item{eta_tilde}{Hyperparameter}

\item{alpha}{Hyperparameter}

\item{beta}{Hyperparameter}

\item{theta_tilde}{Hyperparameter}

\item{tau_eta}{Hyperparameter}

\item{tau_theta}{Hyperparameter}

\item{tau_c}{Hyperparameter}

\item{alpha_chi}{Hyperparameter}

\item{beta_chi}{Hyperparameter}

\item{w_alpha}{Hyperparameter}

\item{clamp_pseudotimes}{This clamps the pseudotimes to their initial values and
doesn't perform sampling. Should be FALSE except for diagnostics.}
}
\value{
An S3 structure with the following entries:
\itemize{
\item \code{traces} A list of iteration-by-dim trace matrices for 
several important variables
\item \code{iter} Number of iterations
\item \code{thin} Thinning applied
\item \code{burn} Burn period at the start of MCMC
\item \code{b} Number of branches modelled
\item \code{prop_collapse} Proportion of updates for gamma that are collapsed
\item \code{N} Number of cells
\item \code{G} Number of features (genes/transcripts)
\item \code{feature_names} Names of features
\item \code{cell_names} Names of cells
}
}
\description{
Perform Gibbs sampling inference for a hierarchical Bayesian mixture of factor analysers
to identify bifurcations in single-cell expression data.
}
\details{
The column names of Y are used as feature (gene/transcript) names while the row names
are used as cell names. If either of these is undefined then the corresponding names
are set to cell_x or feature_y.

It is recommended the form of Y is analogous to log-expression to mitigate the impact of 
outliers.

In the absence of prior information, three valid local maxima in the posterior likelihood
exist (see manuscript). Setting the initial values to a principal component typically
fixes sampling to one of them, analogous to specifying a root cell in similar methods.

The hyper-parameter \code{eta_tilde} represents the expected expression in the absence of
any actual expression measurements. While a Bayesian purist might reason this based on 
knowledge of the measurement technology, simply taking the mean of the input matrix in
an Empirical Bayes style seems reasonable.

The degree of shrinkage of the factor loading matrices to a common value is given by the
gamma prior on \code{chi}. The mean of this is \code{alpha_chi / beta_chi} while the variance 
\code{alpha_chi / beta_chi^2}. Therefore, to obtain higher levels of shrinkage increase
\code{alpha_chi} with respect to \code{beta_chi}.

The collapsed Gibbs sampling option given by \code{collapse} involves marginalising out
\code{c} (the factor loading intercepts) when updating the branch assignment parameters
\code{gamma} which tends to soften the branch assignments.

If zero inflation is enabled using the \code{zero_inflation} parameter then scaling should 
*not* be enabled.
}
\examples{
synth <- create_synthetic(C = 20, G = 5)
m <- mfa(synth$X)
}
