% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfa.R
\name{calculate_chi}
\alias{calculate_chi}
\title{Calculate posterior chi precision parameters}
\usage{
calculate_chi(m)
}
\arguments{
\item{m}{A fit returned from \code{mfa}}
}
\value{
A \code{data_frame} with one entry for the feature names and one
for the MAP estimates of chi (using the \code{posterior.mode} function 
from \code{MCMCglmm}).
}
\description{
Calculates a data frame of the MAP estimates of \eqn{\chi}.
}
\examples{
synth <- create_synthetic(C = 20, G = 5)
m <- mfa(synth$X)
chi_map <- calculate_chi(m)
}
