% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessSingleMolecule.R
\name{runAlign}
\alias{runAlign}
\title{Align the single-molecule data}
\usage{
runAlign(
  ref,
  fasta,
  fasta_subset = seq(1, length(fasta)),
  multicoreParam = NULL,
  updateProgress = NULL,
  log_file = NULL,
  score_cutoff = NULL
)
}
\arguments{
\item{ref}{A reference sequence to align the reads to.}

\item{fasta}{A list of reads/sequences from a single-molecule experiment (e.g. MAPit)}

\item{fasta_subset}{(optional) A vector of indices indicating which
sequences to process if a subset should be used. Leave this blank if
all sequences should be processed.}

\item{multicoreParam}{(optional) A MulticoreParam object, used to align
sequences in parallel.}

\item{updateProgress}{(optional) Used to add a progress bar to the Shiny app.
Should not be used otherwise.}

\item{log_file}{(optional) String indicating where to save a log of the
alignment process. If left NULL, no log is saved. We highly recommend
saving a log file.}

\item{score_cutoff}{(optional) Used mostly for testing purposes.}
}
\value{
The output is a list containing the the matrices 'gch' and 'hcg.
      Each is a dataframe with reads/cells on the rows and each column
     is a base-pair. The matrix represents the methylation state for cell
     across all base pairs. The coding is as follows:
         -2: unmethylated GCH or HCG site
         -1: base pairs between two unmethylated GCH or HCG sites
         0: base pairs between mismatching methylation states of
             two GCH or HCG sites
         1: base pairs between two methylated GCH or HCG sites
         2: methylated GCH or HCG site
}
\description{
Runs the preprocessing methods for single-molecule data.
}
\examples{

data(reads_sm)
data(ref_seq)
example_alignedseq <- runAlign(fasta = reads_sm, ref = ref_seq[[1]], fasta_subset = 1:150)
}
