% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/diffMeth.R, R/methylDBClasses.R
\docType{methods}
\name{select}
\alias{select}
\alias{select,methylBase-method}
\alias{select,methylRaw-method}
\alias{select,methylDiff-method}
\alias{select,methylRawDB-method}
\alias{select,methylBaseDB-method}
\alias{select,methylDiffDB-method}
\title{selects rows from of methylKit objects}
\usage{
select(x,i)

\S4method{select}{methylBase}(x, i)

\S4method{select}{methylRaw}(x, i)

\S4method{select}{methylDiff}(x, i)

\S4method{select}{methylRawDB}(x, i)

\S4method{select}{methylBaseDB}(x, i)

\S4method{select}{methylDiffDB}(x, i)
}
\arguments{
\item{x}{an \code{\link{methylBase}},\code{\link{methylBaseDB}},
\code{\link{methylRaw}},\code{\link{methylRawDB}} or
 \code{\link{methylDiff}} object}

\item{i}{a numeric or logical vector. This vector corresponds to bases or 
regions contained in \code{methylKit} objects.The vector is used to 
subset the data.}
}
\value{
a \code{\link{methylBase}},\code{\link{methylRaw}} or 
          \code{\link{methylDiff}} object depending on the input object.
}
\description{
The function returns a subset of data contained in the \code{methylKit} 
objects.
}
\examples{
data(methylKit)


methylRawDB.obj=methRead( system.file("extdata","test1.txt.bgz",package="methylKit"),
                          sample.id="test1", assembly="hg18",
                          dbtype = "tabix",dbdir = "methylDB")

methylBaseDB.obj=unite(methylRawList.obj,save.db=TRUE,dbdir="methylDB")


 # selects first hundred rows, returns a methylRaw object
subset1=select(methylRawList.obj[[1]],1:100)
subset1=select(methylRawDB.obj,1:100)

# selects first hundred rows, returns a methylBase object
subset2=select(methylBase.obj,1:100) 
subset2=select(methylBaseDB.obj,1:100)

# selects first hundred rows, returns a methylDiff object
subset3=select(methylDiff.obj,1:100)




# remove Database again
rm(methylBaseDB.obj)
rm(methylRawDB.obj)
unlink("methylDB",recursive=TRUE)

}
