% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylDBClasses.R
\docType{methods}
\name{makeMethylDB}
\alias{makeMethylDB}
\alias{makeMethylDB,methylBase-method}
\alias{makeMethylDB,methylBase-methods}
\alias{makeMethylDB,methylRaw-method}
\alias{makeMethylDB,methylRaw-methods}
\alias{makeMethylDB,methylDiff-method}
\alias{makeMethylDB,methylDiff-methods}
\alias{makeMethylDB,methylRawList-method}
\alias{makeMethylDB,methylRawList-methods}
\title{coerce methylKit objects from memory to flat file database objects}
\usage{
makeMethylDB(obj, dbdir = getwd())

\S4method{makeMethylDB}{methylBase}(obj, dbdir = getwd())

\S4method{makeMethylDB}{methylRaw}(obj, dbdir = getwd())

\S4method{makeMethylDB}{methylDiff}(obj, dbdir = getwd())

\S4method{makeMethylDB}{methylRawList}(obj, dbdir = getwd())
}
\arguments{
\item{obj}{an \code{\link{methylBase}},
\code{\link{methylRaw}},
\code{\link{methylRawList}} or an \code{\link{methylDiff}} object}

\item{dbdir}{directory where flat file database(s) should be stored, 
defaults to getwd(), working directory.}
}
\value{
an \code{\link{methylBaseDB}},\code{\link{methylRawDB}},
\code{\link{methylRawListDB}} or an \code{\link{methylDiffDB}} object
}
\description{
The function converts in-memory methylKit objects to methylDB objects
}
\examples{
\dontrun{
data(methylKit)


makeMethylDB(methylBase.obj,"my/path")
}

}
