% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/diffMeth.R, R/methylDBClasses.R
\docType{methods}
\name{getAssembly}
\alias{getAssembly}
\alias{getAssembly,methylBase-method}
\alias{getAssembly,methylRaw-method}
\alias{getAssembly,methylDiff-method}
\alias{getAssembly,methylRawDB-method}
\alias{getAssembly,methylBaseDB-method}
\alias{getAssembly,methylDiffDB-method}
\title{get assembly of the genome}
\usage{
getAssembly(x)

\S4method{getAssembly}{methylBase}(x)

\S4method{getAssembly}{methylRaw}(x)

\S4method{getAssembly}{methylDiff}(x)

\S4method{getAssembly}{methylRawDB}(x)

\S4method{getAssembly}{methylBaseDB}(x)

\S4method{getAssembly}{methylDiffDB}(x)
}
\arguments{
\item{x}{an \code{\link{methylBase}},\code{\link{methylBaseDB}},
\code{\link{methylRaw}},\code{\link{methylRawDB}} or \code{\link{methylDiff}} object}
}
\value{
the assembly string for the object
}
\description{
The function returns the genome assembly stored in any of the 
\code{\link{methylBase}},\code{\link{methylBaseDB}},\code{\link{methylRaw}},
\code{\link{methylRawDB}},\code{\link{methylDiff}} objects
}
\examples{

data(methylKit)

getAssembly(methylBase.obj)
getAssembly(methylDiff.obj)
getAssembly(methylRawList.obj[[1]])


}
