% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceInternalMethods.R
\name{validateRunObservation}
\alias{validateRunObservation}
\title{Validation of some parameters of the
\code{\link{runObservation}} function}
\usage{
validateRunObservation(
  methylKitData,
  type,
  outputDir,
  nbrCoresDiffMeth,
  minReads,
  minMethDiff,
  qvalue,
  maxPercReads,
  destrand,
  minCovBasesForTiles,
  tileSize,
  stepSize,
  vSeed,
  restartCalculation,
  saveInfoByGeneration
)
}
\arguments{
\item{methylKitData}{a \code{list} of \code{methylRawList} entries or the
name of the RDS file containing the list. Each
\code{methylRawList} contains all the \code{methylRaw} entries related to
one generation (first entry = first generation, second entry = second
generation, etc..). The number of generations must correspond to the number
of entries in the \code{methylKitData}. At least 2 generations
must be present to calculate the conserved elements. More information can
be found in the methylKit package.}

\item{type}{One of the "sites","tiles" or "both" strings. Specifies the type
of differentially methylated elements should be returned. For
retrieving differentially methylated bases type="sites"; for
differentially methylated regions type="tiles". Default: "both".}

\item{outputDir}{a string, the name of the directory that will contain
the results of the permutation. If the directory does not exist, it will
be created.}

\item{nbrCoresDiffMeth}{a positive \code{integer}, the number of cores
to use for parallel differential methylation calculations.Parameter
used for both sites and tiles analysis. The parameter
corresponds to the \code{num.cores} parameter in
the \code{methylKit} package.}

\item{minReads}{a positive \code{integer} Bases and regions having lower
coverage than this count are discarded. The parameter
correspond to the \code{lo.count} parameter in the  \code{methylKit}
package.}

\item{minMethDiff}{a positive \code{double} betwwen [0,100], the absolute
value of methylation percentage change between cases and controls. The
parameter correspond to the \code{difference} parameter in
the \code{methylKit} package.}

\item{qvalue}{a positive \code{double} betwwen [0,1], the cutoff
for qvalue of differential methylation statistic.}

\item{maxPercReads}{a \code{double} between [0,100], the percentile of read
counts that is going to be used as upper cutoff. Bases ore regions
having higher
coverage than this percentile are discarded. Parameter used for both CpG
sites and tiles analysis. The parameter
correspond to the \code{hi.perc} parameter in the  \code{methylKit} package.}

\item{destrand}{a \code{logical}, when \code{TRUE} will merge reads on both
strands of a CpG dinucleotide to provide better coverage. Only advised
when looking at CpG methylation. Parameter used for both CpG
sites and tiles analysis.}

\item{minCovBasesForTiles}{a non-negative \code{integer}, the minimum
number of bases to be covered in a given tiling window. The parameter
corresponds to the \code{cov.bases} parameter in the package
\code{methylKit}. Only used when \code{doingTiles} =
\code{TRUE}. Default: \code{0}.}

\item{tileSize}{a positive \code{integer}, the size of the tiling window.
The parameter corresponds to the \code{win.size} parameter in
the  \code{methylKit} package. Only
used when \code{doingTiles} = \code{TRUE}.}

\item{stepSize}{a positive \code{integer}, the step size of tiling windows.
The parameter corresponds to the \code{stepSize} parameter in
the  \code{methylKit} package. Only
used when \code{doingTiles} = \code{TRUE}.}

\item{vSeed}{a \code{integer}, a seed used when reproducible results are
needed. When a value inferior or equal to zero is given, a random integer
is used.}

\item{restartCalculation}{a \code{logical}, when \code{TRUE}, only
permutations that don't have an associated RDS result file are run. Useful
to restart a permutation analysis that has been interrupted.}

\item{saveInfoByGeneration}{a \code{logical}, when \code{TRUE}, the
information about differentially methylated sites and tiles for each
generation is saved in a RDS file. The information is saved in a different
file for each permutation. The files are only saved when the
\code{outputDir} is not \code{NULL}.}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validation of some parameters needed by the public
\code{\link{runObservation}} function.
}
\examples{

## Load dataset
data(samplesForTransgenerationalAnalysis)

## The function returns 0 when all paramaters are valid
methylInheritance:::validateRunObservation(
    methylKitData = samplesForTransgenerationalAnalysis, type = "sites",
    outputDir = "test", nbrCoresDiffMeth = 1, minReads = 10,
    minMethDiff = 25, qvalue = 0.01,
    maxPercReads = 99.9, destrand = TRUE, minCovBasesForTiles = 10,
    tileSize = 1000, stepSize = 500, vSeed = 12, restartCalculation = TRUE,
    saveInfoByGeneration = FALSE)

## The function raises an error when at least one paramater is not valid
\dontrun{methylInheritance:::validateRunObservation(
    methylKitData = samplesForTransgenerationalAnalysis,
    type = "tiles", outputDir = "test_02", nbrCoresDiffMeth = 1,
    minReads = "HI", minMethDiff = 25, qvalue = 0.01,
    maxPercReads = 99.9, destrand = TRUE, minCovBasesForTiles = 10,
    tileSize = 1000, stepSize = 500, vSeed = 12, restartCalculation = FALSE,
    saveInfoByGeneration = FALSE)}

}
\author{
Astrid Deschenes
}
\keyword{internal}
