% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceInternalMethods.R
\name{validateExtractInfo}
\alias{validateExtractInfo}
\title{Validation of some parameters of the
\code{\link{extractInfo}} function}
\usage{
validateExtractInfo(allResults, type, inter, position)
}
\arguments{
\item{allResults}{a \code{list} as created by the
\code{runPermutation} or the \code{loadAllRDSResults} functions.}

\item{type}{One of the \code{"sites"} or \code{"tiles"} strings.
Specifies the type
of differentially methylated elements should be returned. For
retrieving differentially methylated bases \code{type} = \code{"sites"}; for
differentially methylated regions \code{type} = \code{"tiles"}.}

\item{inter}{One of the \code{"i2"} or \code{"iAll"} strings. Specifies the
type of intersection should be returned. For
retrieving intersection results between two consecutive generations
\code{inter} = \code{"i2"}; for intersection results between three
generations or more \code{inter} = \code{"iAll"}.}

\item{position}{a positive \code{integer}, the position in the \code{list}
where the information will be extracted. The position must be an existing
position inside \code{allResults}}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validation of some parameters needed by the public
\code{\link{extractInfo}} function.
}
\examples{

## Load dataset
data(methylInheritanceResults)

## The function returns 0 when all paramaters are valid
methylInheritance:::validateExtractInfo(
    allResults = methylInheritanceResults, type = "sites",
    inter = "i2", 2)

## The function raises an error when at least one paramater is not valid
\dontrun{methylInheritance:::validateExtractInfo(
    allResults = methylInheritanceResults, type = "sites",
    inter = "i2", 12)}

}
\author{
Astrid Deschenes
}
\keyword{internal}
