% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceMethods.R
\name{plotGraph}
\alias{plotGraph}
\title{Generate a graph for a permutation analysis}
\usage{
plotGraph(formatForGraphDataFrame)
}
\arguments{
\item{formatForGraphDataFrame}{a \code{data.frame} containing the
observation results (using real
data) and the permutation results (using shuffled data). Both hyper and
hypo differentially conserved methylation results must be present. The
\code{data.frame} must have 3 columns : "TYPE", "RESULT" and "SOURCE".
The "TYPE" can be either "HYPER" or "HYPO". The "RESULT" is the number
of conserved differentially elements. The "SOURCE" can be either
"OBSERVATION" or "PERMUTATION".}
}
\value{
a graph showing the permutation analysis results
}
\description{
Generate a graph for a permutation analysis using observed
and shuffled results.
}
\examples{

## Loading dataset containing all results
data(methylInheritanceResults)

## Extract information for the intersection between conserved differentially
## methylated sites (type = sites) between the intersection of 2
## generations (inter = i2): F2 and F3 (position = 2)
info <- extractInfo(allResults = methylInheritanceResults,
    type = "sites", inter="i2", 2)

## Create graph
plotGraph(info)

}
\author{
Astrid Deschenes, Pascal Belleau
}
