[![Build Status](https://travis-ci.org/adeschen/methylInheritance.svg?branch=master)](https://travis-ci.org/adeschen/methylInheritance)
[![codecov](https://codecov.io/gh/adeschen/methylInheritance/branch/master/graph/badge.svg)](https://codecov.io/gh/adeschen/methylInheritance)
[![License: Artistic-2.0](https://img.shields.io/badge/License-Artistic%202.0-0298c3.svg)](https://opensource.org/licenses/Artistic-2.0)

## Conserved Differentially Methylated Elements from One Generation to the Next: Inheritance versus Randomness


The **methylInheritance** package implements a permutation analysis, based 
on Monte Carlo sampling, for testing the 
hypothesis that the number of conserved differentially methylated 
elements, between several generations, is 
associated to an effect inherited from a treatment and that stochastic effect 
can be dismissed. 


## Citing ##

If you use this package for a publication, we would ask you to cite the 
following:

> Pascal Belleau, Astrid Deschênes, Marie-Pier Scott-Boyer, Romain Lambrot, Mathieu Dalvai, Sarah Kimmins, Janice Bailey, Arnaud Droit; Inferring and modeling inheritance of differentially methylated changes across multiple generations, Nucleic Acids Research, Volume 46, Issue 14, 21 August 2018, Pages e85. DOI: https://doi.org/10.1093/nar/gky362


## Bioconductor Package ##

[![Bioconductor Time](http://bioconductor.org/shields/years-in-bioc/methylInheritance.svg)](http://bioconductor.org/packages/release/bioc/html/methylInheritance.html "Bioconductor status")

methylInheritance is now an official package of [Bioconductor](http://bioconductor.org/). The current release can be directly downloaded from their website:
[Current release](http://bioconductor.org/packages/methylInheritance)


## Description of Package Functionality ##

The vignette of the methylInheritance package, which is a document that provides a task-oriented description of the package functionality, is available on Bioconductor website:
[methylInheritance vignette](https://bioconductor.org/packages/release/bioc/vignettes/methylInheritance/inst/doc/methylInheritance.html)


## Authors ##

[Astrid Desch&ecirc;nes](http://ca.linkedin.com/in/astriddeschenes "Astrid Desch&ecirc;nes"), 
[Pascal Belleau](http://ca.linkedin.com/in/pascalbelleau "Pascal Belleau")
and [Arnaud Droit](http://ca.linkedin.com/in/drarnaud "Arnaud Droit").


## License ##

This package and the underlying methylInheritance code are distributed under 
the Artistic license 2.0. You are free to use and redistribute this software. 

For more information on Artistic 2.0 License see
[http://opensource.org/licenses/Artistic-2.0](http://opensource.org/licenses/Artistic-2.0)


## Bugs/Feature requests ##

If you have any bugs or feature requests, 
[let us know](https://github.com/adeschen/methylInheritance/issues). 

Thanks!
