% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{estimatecc-class}
\alias{estimatecc-class}
\title{the estimatecc class}
\value{
\code{summary} returns the summary information 
about the cell composition estimate procedure and 
\code{cell_counts} returns the cell composition estimates
}
\description{
Objects of this class store all 
the values needed information to work with a
estimatecc object
}
\section{Slots}{

\describe{
\item{\code{summary}}{information about the samples and 
regions used to estimate cell composition}

\item{\code{cell_counts}}{cell composition estimates}
}}

\examples{
# This is a reduced version of the FlowSorted.Blood.450k 
# dataset available by using BiocManager::install("FlowSorted.Blood.450k),
# but for purposes of the example, we use the smaller version 
# and we set \\code{demo=TRUE}. For any case outside of this example for 
# the package, you should set \\code{demo=FALSE} (the default). 

dir <- system.file("data", package="methylCC")
files <- file.path(dir, "FlowSorted.Blood.450k.sub.RData") 
if(file.exists(files)){
    load(file = files)

    set.seed(12345)
    est <- estimatecc(object = FlowSorted.Blood.450k.sub, demo = TRUE) 
    cell_counts(est)
 }   

}
