% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dmrs.R
\name{.find_dmrs}
\alias{.find_dmrs}
\title{Finding differentially methylated regions}
\usage{
.find_dmrs(verbose = TRUE, gr_target = NULL, include_cpgs = FALSE,
  include_dmrs = TRUE, num_cpgs = 50, num_regions = 50,
  bumphunter_beta_cutoff = 0.2, dmr_up_cutoff = 0.5,
  dmr_down_cutoff = 0.4, dmr_pval_cutoff = 1e-11,
  cpg_pval_cutoff = 1e-08, cpg_up_dm_cutoff = 0,
  cpg_down_dm_cutoff = 0, pairwise_comparison = FALSE,
  mset_train_flow_sort = NULL)
}
\arguments{
\item{verbose}{TRUE/FALSE argument specifying if verbose
messages should be returned or not. Default is TRUE.}

\item{gr_target}{Default is NULL. However, the user 
can provide a GRanges object from the \code{object} 
in \code{estimatecc}. Before starting the procedure to 
find differentially methylated regions, the intersection
of the \code{gr_target} and GRanges object from the 
reference methylomes (\code{FlowSorted.Blood.450k}).}

\item{include_cpgs}{TRUE/FALSE. Should individual CpGs
be returned. Default is FALSE.}

\item{include_dmrs}{TRUE/FALSE. Should differentially 
methylated regions be returned. Default is TRUE. User
can turn this to FALSE and search for only CpGs.}

\item{num_cpgs}{The max number of CpGs to return 
for each cell type. Default is 50.}

\item{num_regions}{The max number of DMRs to return 
for each cell type. Default is 50.}

\item{bumphunter_beta_cutoff}{The \code{cutoff} threshold 
in \code{bumphunter()} in the \code{bumphunter} package.}

\item{dmr_up_cutoff}{A cutoff threshold for identifying 
DMRs that are methylated in one cell type, but not in the 
other cell types.}

\item{dmr_down_cutoff}{A cutoff threshold for identifying 
DMRs that are not methylated in one cell type, but 
methylated in the other cell types.}

\item{dmr_pval_cutoff}{A cutoff threshold for the p-values 
when identifying DMRs that are methylated in one cell 
type, but not in the other cell types (or vice versa).}

\item{cpg_pval_cutoff}{A cutoff threshold for the p-values 
when identifying differentially methylated CpGs that are
methylated in one cell type, but not in the other cell
types (or vice versa).}

\item{cpg_up_dm_cutoff}{A cutoff threshold for identifying 
differentially methylated CpGs that are methylated in 
one cell type, but not in the other cell types.}

\item{cpg_down_dm_cutoff}{A cutoff threshold for identifying 
differentially methylated CpGs that are not methylated in 
one cell type, but are methylated in the other cell types.}

\item{pairwise_comparison}{TRUE/FAlSE of whether all pairwise
comparisons (e.g. methylated in Granulocytes and Monocytes, 
but not methylated in other cell types). Default if FALSE.}

\item{mset_train_flow_sort}{Default is NULL. However, a user
can provide a \code{MethylSet} object after processing the 
\code{FlowSorted.Blood.450k} dataset. The default normalization
is \code{preprocessIllumina()}.}
}
\value{
A list of data frames and GRanges objects.
}
\description{
This function uses the \code{FlowSorted.Blood.450k}
whole blood reference methylomes with six cell types 
to identify differentially methylated regions.
}
