% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_bedgraphs.R
\name{write_bedgraphs}
\alias{write_bedgraphs}
\title{Writes bedGraphs from methrix object}
\usage{
write_bedgraphs(
  m,
  output_dir = NULL,
  rm_NA = TRUE,
  force = FALSE,
  n_thr = 4,
  compress = TRUE,
  SeqStyle = "UCSC",
  multiBed = NULL,
  metilene = FALSE,
  phenoCol = NULL,
  add_coverage = FALSE
)
}
\arguments{
\item{m}{\code{\link{methrix}} object}

\item{output_dir}{Output directory name where the files should be saved.
If \code{NULL} creats a \code{tempdir}}

\item{rm_NA}{remove NAs}

\item{force}{forces to create files if they are existing}

\item{n_thr}{Default 4.}

\item{compress}{Whether to compress the output. Default TRUE}

\item{SeqStyle}{Default `UCSC` with `chr` prefix.}

\item{multiBed}{Default NULL. If provided a filename, a single bedGraph file with all samples included is generated.}

\item{metilene}{Default FALSE. If TRUE outputs bedgraphs in `metilene` format that can be directly used for DMR calling with `metilene`. This option works only when \code{multiBed = TRUE}.}

\item{phenoCol}{Default NULL. `condition` column from colData. Only applicable if \code{metilene = TRUE}}
\item{add_coverage}{Should the output file contain information on coverage? Default FALSE}
}
\value{
writes bedgraph files to output
}
\description{
Writes bedGraphs from methrix object
}
\examples{
data('methrix_data')
write_bedgraphs(m = methrix_data, output_dir = './temp')
#Export to metline format for DMR calling with metline
write_bedgraphs(m = methrix_data, output_dir = "./temp", rm_NA = FALSE,
metilene = TRUE,multiBed = "metline_ip", phenoCol = "Condition")
}
