% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_report.R
\name{methrix_report}
\alias{methrix_report}
\title{Creates a detailed interative html summary report from Methrix object}
\usage{
methrix_report(
  meth,
  output_dir = NULL,
  recal_stats = FALSE,
  plot_beta_dist = TRUE,
  beta_nCpG = 10000,
  prefix = NULL,
  n_thr = 4
)
}
\arguments{
\item{meth}{\code{\link{methrix}} object}

\item{output_dir}{Output directory name where the files should be saved. If \code{NULL} creats a \code{tempdir}}

\item{recal_stats}{Whether summary statistics should be recalculated? If you are using subsetted methrix object set this to TRUE.}

\item{plot_beta_dist}{Default TRUE. Can be time consuming.}

\item{beta_nCpG}{Number of CpGs rto use for estimating beta value distribution. Default 10000}

\item{prefix}{If provided, the name of the report and the intermediate files will start with the prefix.}

\item{n_thr}{Default 4. Only used if \code{plot_beta_dist} is TRUE}
}
\value{
an interactive html report
}
\description{
Creates a detailed interative html summary report from Methrix object.
If the directory contains required files (from previous run), it directly proceeds to generate html report.
}
\examples{
\dontrun{
data('methrix_data')
methrix::methrix_report(meth = methrix_data)
}
}
