% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methrix_operations.R
\name{get_region_summary}
\alias{get_region_summary}
\title{Extract and summarize methylation or coverage info by regions of interest}
\usage{
get_region_summary(
  m,
  regions = NULL,
  type = "M",
  how = "mean",
  overlap_type = "within",
  na_rm = TRUE,
  elementMetadata.col = NULL,
  verbose = TRUE,
  n_chunks = 1,
  n_cores = 1
)
}
\arguments{
\item{m}{\code{\link{methrix}} object}

\item{regions}{genomic regions to be summarized. Could be a data.table with 3 columns (chr, start, end) or a \code{GenomicRanges} object}

\item{type}{matrix which needs to be summarized. Coule be `M`, `C`. Default 'M'}

\item{how}{mathematical function by which regions should be summarized. Can be one of the following: mean, sum, max, min. Default 'mean'}

\item{overlap_type}{defines the type of the overlap of the CpG sites with the target region. Default value is `within`. For detailed description,
see the \code{findOverlaps} function of the \code{\link{IRanges}} package.}

\item{na_rm}{Remove NA's? Default \code{TRUE}}

\item{elementMetadata.col}{columns in \code{rowData(\link{methrix})} which needs to be summarised. Default = NULL.}

\item{verbose}{Default TRUE}

\item{n_chunks}{Number of chunks to split the \code{\link{methrix}} object in case it is very large. Default = 1.}

\item{n_cores}{Number of parallel instances. \code{n_cores} should be less than or equal to \code{n_chunks}. If \code{n_chunks} is not specified, then \code{n_chunks} is initialized to be equal to \code{n_cores}. Default = 1.}
}
\value{
a coverage or methylation matrix
}
\description{
Extract and summarize methylation or coverage info by regions of interest
}
\details{
Takes \code{\link{methrix}} object and summarizes regions
}
\examples{
data('methrix_data')
get_region_summary(m = methrix_data,
regions = data.table(chr = 'chr21', start = 27867971, end =  27868103),
type = 'M', how = 'mean')
}
