% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granges_manipulation.R
\name{strandedDistance}
\alias{strandedDistance}
\title{Calculate distances of query GRanges upstream or downstream of subject GRanges}
\usage{
strandedDistance(query_gr, subject_gr)
}
\arguments{
\item{query_gr}{A GRanges object}

\item{subject_gr}{A GRanges object.}
}
\value{
A numeric vector of distances
}
\description{
Upstream and downstream are relative to the strand of subject_gr.
Unstranded regions are treated the same as regions on the "+" strand.
}
\examples{
# Create query and subject GRanges 
query_gr <- GenomicRanges::GRanges(c("chr1:100-1000:+", "chr1:2000-3000:-"))
subject_gr <- GenomicRanges::GRanges(c("chr1:1500-1600:+", "chr1:4000-4500:-"))

# Calculate distances between query and subject
methodical::strandedDistance(query_gr, subject_gr)
}
