% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granges_manipulation.R
\name{.calculate_regions_intersections}
\alias{.calculate_regions_intersections}
\title{Calculate the number of bases in the intersection of two GRanges objects}
\usage{
.calculate_regions_intersections(
  gr1,
  gr2,
  ignore.strand = TRUE,
  overlap_measure = "absolute"
)
}
\arguments{
\item{gr1}{A GRanges object}

\item{gr2}{A GRanges object}

\item{ignore.strand}{TRUE or FALSE indicating whether strand should be ignored when calculating intersections. Default is TRUE.}

\item{overlap_measure}{One of "absolute", "proportion" or "jaccard" indicating whether to calculate
the absolute size of the intersection in base pairs, the proportion base pairs of gr1 overlapping gr2
or the Jaccard index of the intersection in terms of base pairs. Default value is "absolute".}
}
\value{
An numeric value
}
\description{
Calculate the number of bases in the intersection of two GRanges objects
}
