% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{annotatePlot}
\alias{annotatePlot}
\title{Create a plot with genomic annotation for a plot of values at methylation sites.}
\usage{
annotatePlot(
  meth_site_plot,
  annotation_grl,
  reference_tss = FALSE,
  grl_colours = NULL,
  annotation_line_size = 5,
  ylab = "Genome Annotation",
  annotation_plot_proportion = 0.5,
  keep_meth_site_plot_legend = FALSE,
  annotation_plot_only = FALSE
)
}
\arguments{
\item{meth_site_plot}{A plot of methylation site values (generally methylation level or correlation of methylation with transcription) around a TSS}

\item{annotation_grl}{A GRangesList object (or list coercible to a GRangesList) where each component GRanges gives
the locations of different classes of regions to display. Each class of region will
be given a separate colour in the plot, with regions ordered by the order of \code{names(annotation_grl)}.}

\item{reference_tss}{TRUE or FALSE indicating whether to show distances on the X-axis
relative to the TSS stored as an attribute \code{tss_range} of meth_site_plot.
Alternatively, can provide a GRanges object with a single range for such a TSS site.
In either case, will show the distance of methylation sites to the start of this region with methylation sites upstream
relative to the reference_tss shown first.
If FALSE (the default), the x-axis will instead show the start site coordinate of the methylation site.
relative to the reference_tss shown first. If not, the x-axis will show the start site coordinate of the methylation site.}

\item{grl_colours}{An optional vector of colours used to display each of the
GRanges making up annotation_grl. Must have same length as annotation_grl.}

\item{annotation_line_size}{Linewidth for annotation plot. Default is 5.}

\item{ylab}{The title to give the Y axis in the annotation plot. Default is "Genome Annotation".}

\item{annotation_plot_proportion}{A value giving the proportion of the height of the plot devoted to the annotation. Default is 0.5.}

\item{keep_meth_site_plot_legend}{TRUE or FALSE indicating whether to retain the legend of meth_site_plot, if it has one. Default value is FALSE.}

\item{annotation_plot_only}{TRUE or FALSE indicating whether to return only the annotation plot. Default is to combine meth_site_plot with the annotation.}
}
\value{
A ggplot object
}
\description{
Works with plots returned by \code{plotRegionValues()}, \code{plotMethSiteCorCoefs()} or \code{plotMethodicalScores}.
Can combine the meth site values plot and genomic annotation together into a
single plot or return the annotation plot separately.
}
\examples{
# Get CpG islands from UCSC
data("hg38_cpg_islands", package = "methodical")
hg38_cpg_islands <- GRangesList(split(hg38_cpg_islands, hg38_cpg_islands$type))

# Load plot with CpG methylation correlation values for TUBB6
data("tubb6_correlation_plot", package = "methodical")

# Add positions of CpG islands to tubb6_correlation_plot
methodical::annotatePlot(tubb6_correlation_plot, annotation_grl = hg38_cpg_islands, annotation_plot_proportion = 0.3)

}
