% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importData.R
\name{importRene}
\alias{importRene}
\title{Import a Rene methylation extractor file}
\usage{
importRene(file, chrom.lengths = NULL, skip = 1)
}
\arguments{
\item{file}{The file to import.}

\item{chrom.lengths}{A data.frame with chromosome names in the first, and chromosome lengths in the second column. Only chromosomes named in here will be returned. Alternatively a tab-separated file with such a data.frame (with headers).}

\item{skip}{The number of lines to skip. Usually 1 if the file contains a header and 0 otherwise.}
}
\value{
A \code{\link{methimputeData}} object.
}
\description{
Import a Rene methylation extractor file into a \code{\link[GenomicRanges]{GRanges-class}} object.
}
\examples{
## Get an example file in Rene format
file <- system.file("extdata","arabidopsis_rene.txt", package="methimpute")
data(arabidopsis_chromosomes)
rene.data <- methimpute:::importRene(file, chrom.lengths=arabidopsis_chromosomes)

}
