% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{estimateTransDist}
\alias{estimateTransDist}
\title{\code{transDist} parameter}
\usage{
estimateTransDist(distcor, skip = 2, plot.parameters = TRUE)
}
\arguments{
\item{distcor}{The output produced by \code{\link{distanceCorrelation}}.}

\item{skip}{Skip the first n cytosines for the fitting. This can be necessary to avoid periodicity artifacts due to the context definition.}

\item{plot.parameters}{Whether to plot fitted parameters on to the plot or not.}
}
\value{
A list() with fitted \code{transDist} parameters and the corresponding \code{\link[ggplot2]{ggplot}}.
}
\description{
Obtain an estimate for the \code{transDist} parameter (used in function \code{\link{callMethylation}}) by fitting an exponential function to the supplied correlations (from \code{\link{distanceCorrelation}}).
}
\examples{
## Get some toy data
file <- system.file("data","arabidopsis_toydata.RData",
                    package="methimpute")
data <- get(load(file))
distcor <- distanceCorrelation(data)
fit <- estimateTransDist(distcor)
print(fit)
}
