% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{validateRunSimDoubleParameters}
\alias{validateRunSimDoubleParameters}
\title{Parameters validation for the \code{\link{runSim}} function. Only
double parameters are validated.}
\usage{
validateRunSimDoubleParameters(vpDiff, vpDiffsd, vDiff, vInheritance,
  propInherite, rateDiff, minRate, propHetero, maxPercReads)
}
\arguments{
\item{vpDiff}{a \code{double} superior to \code{0} and inferior or equal 
to \code{1}, the mean value for the proportion of samples that will have,
for a specific position, differentially methylated values. It can be 
interpreted as the penetrance.}

\item{vpDiffsd}{a non-negative \code{double}, the standard deviation 
associated to the \code{propDiff}.}

\item{vDiff}{a positive \code{double} between [0,1], the proportion of 
C/T for a case differentially methylated follow a beta distribution 
where the mean is shifted of \code{vDiff} from the CTRL distribution}

\item{vInheritance}{a positive \code{double} between [0,1], the 
proportion of cases that inherited differentially sites.}

\item{propInherite}{a non-negative \code{double} inferior or equal to 
\code{1}, the proportion of differentially methylated site
are inherated}

\item{rateDiff}{a positive \code{double} inferior to \code{1}, the mean of 
the chance that a site is differentially methylated.}

\item{minRate}{a non-negative \code{double} inferior to \code{1}, the 
minimum rate of differentially methylated sites.}

\item{propHetero}{a positive \code{double} between [0,1], the 
reduction of vDiff for the second and following generations.}

\item{maxPercReads}{a \code{double} between [0,100], the percentile of read
counts that is going to be used as upper cutoff. Bases ore regions
having higher
coverage than this percentile are discarded. Parameter used for both CpG
sites and tiles analysis. The parameter
correspond to the \code{hi.perc} parameter in the  \code{methylKit} package.}
}
\value{
\code{0} indicating that the function has been successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{runSim}} function. Only double parameters are validated.
}
\examples{

## The function returns 0 when all paramaters are valid
methInheritSim:::validateRunSimDoubleParameters(vpDiff =0.2, 
vpDiffsd = 0.3, vDiff = 0.4, vInheritance = 0.2, propInherite = 0.5, 
rateDiff = 0.2, minRate = 0.1, propHetero = 0.2, maxPercReads = 99.1)

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
