% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{getSyntheticChr}
\alias{getSyntheticChr}
\title{Create a synthetic chromosome with the CTRL genome}
\usage{
getSyntheticChr(methInfo, nbBlock, nbCpG)
}
\arguments{
\item{methInfo}{is object of class \code{methylBase}, the CpG information
from controls (CTRL) that will be used to create the sythetic chromosome. 
The object can also contain information from cases but only the controls 
will be used.}

\item{nbBlock}{a positive \code{integer}, the number of blocks used 
for sampling.}

\item{nbCpG}{a \code{integer}, the number of consecutive CpG positions used
for sampling from \code{methInfo}.}
}
\value{
a \code{GRanges} object, the synthetic chromosome.
}
\description{
Create a synthetic chromosome with the sampling of a specified 
number of blocks and a specified number of consecutive CpG.
}
\examples{

## Load methyl information
data(samplesForChrSynthetic)

## Ensure results are reproducible
set.seed(32)

## Create synthetic chromosome
methInheritSim:::getSyntheticChr(methInfo = samplesForChrSynthetic, 
nbBlock = 10, nbCpG = 20)

}
\author{
Pascal Belleau
}
\keyword{internal}
