% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_from_metagene.R
\name{metagene2_heatmap}
\alias{metagene2_heatmap}
\title{Plots a heatmap of coverages from a metagene2 object.}
\usage{
metagene2_heatmap(
  metagene,
  region_order = as_is_region_order(metagene),
  scale_trans = "identity"
)
}
\arguments{
\item{metagene}{The metagene object to be plotted as a heatmap.}

\item{region_order}{A named list with as many elements as there are region 
groups, with each element containing an ordering for the 
regions within that group. 
The \code{\link{as_is_region_order}} and 
\code{\link{coverage_order}} functions can be used to
generate a valid ordering. By default, 
\code{\link{as_is_region_order}} is used.}

\item{scale_trans}{A character string giving the transformation that should
be applied to the coverage values. Common values are
"identity" and "log1p". See the ggplot2 documentation for
scale_continuous for more details.}
}
\value{
A ggplot object containing a heatmap representation of the metagene2 
        object.
}
\description{
This function creates an ordering of regions within region groups based on 
ascending or descending mean coverage. This is used with the 
\code{\link{metagene2_heatmap}} function.
}
\examples{
  demo_metagene = get_demo_metagene()
  metagene2_heatmap(demo_metagene)
}
