% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_binning.R
\name{hierarchical_binning}
\alias{hierarchical_binning}
\title{Hierarchical (ABxCB) binning on metagenomic samples}
\usage{
hierarchical_binning(
  ...,
  eMin = 1,
  eMax = 0,
  kMerSizeAB = 10,
  kMerSizeCB = 4,
  genomeSize = 3e+06,
  numOfClustersAB = 3,
  outputC = "ABxCB.cluster",
  keepQuality = FALSE,
  dryRun = FALSE,
  gzip = FALSE,
  numOfThreads = 1
)
}
\arguments{
\item{...}{Input fasta/fastq files locations
(uncompressed or gzip compressed).}

\item{eMin}{Exclude kmers of less or equal count.}

\item{eMax}{Exclude kmers of more or equal count.}

\item{kMerSizeAB}{kmer length for Abundance based Binning.}

\item{kMerSizeCB}{kmer length for Composition based Binning.}

\item{genomeSize}{Average genome size of taxa in the metagenome data.}

\item{numOfClustersAB}{Number of Clusters for Abundance based Binning.}

\item{outputC}{Output Hierarchical Binning (ABxCB) Clusters
files location and prefix.}

\item{keepQuality}{Keep fastq qualities on the output files.
(will produce .fastq)}

\item{dryRun}{Don't write any output files.}

\item{gzip}{Gzip output files.}

\item{numOfThreads}{Number of threads to use.}
}
\value{
A \code{\link[base]{data.frame}} of the binning assignments.
    Return value contains \code{numOfClustersAB + 2} columns.
\itemize{
    \item \code{read_id} : read identifier from fasta header
    \item \code{ABxCB} : read was assigned to this ABxCB cluster index
    \item \code{ABxCB.n} : read to cluster ABxCB.n distance
}
}
\description{
This function performs hierarchical binning on metagenomic samples,
directly from FASTA or FASTQ files.
First it analyzes sequences by long kmer analysis (k>8),
as in \code{\link[metabinR]{abundance_based_binning}}.
Then for each AB bin, it guesses the number of composition bins in it and
performs composition based binning by short kmer analysis (k<8),
as in \code{\link[metabinR]{composition_based_binning}}.
See \doi{10.1186/s12859-016-1186-3} for more details.
}
\examples{
hierarchical_binning(
    system.file("extdata", "reads.metagenome.fasta.gz",package = "metabinR"),
    dryRun = TRUE, kMerSizeAB = 4, kMerSizeCB = 2
)
}
\references{
\url{https://github.com/gkanogiannis/metabinR}
}
\author{
Anestis Gkanogiannis, \email{anestis@gkanogiannis.com}
}
