% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composition_based_binning.R
\name{composition_based_binning}
\alias{composition_based_binning}
\title{Composition based binning on metagenomic samples}
\usage{
composition_based_binning(
  ...,
  kMerSizeCB = 4,
  numOfClustersCB = 5,
  outputCB = "CB.cluster",
  keepQuality = FALSE,
  dryRun = FALSE,
  gzip = FALSE,
  numOfThreads = 1
)
}
\arguments{
\item{...}{Input fasta/fastq files locations
(uncompressed or gzip compressed).}

\item{kMerSizeCB}{kmer length for Composition based Binning.}

\item{numOfClustersCB}{Number of Clusters for Composition based Binning.}

\item{outputCB}{Output Composition based Binning Clusters
files location and prefix.}

\item{keepQuality}{Keep fastq qualities on the output files.
(will produce .fastq)}

\item{dryRun}{Don't write any output files.}

\item{gzip}{Gzip output files.}

\item{numOfThreads}{Number of threads to use.}
}
\value{
A \code{\link[base]{data.frame}} of the binning assignments.
    Return value contains \code{numOfClustersCB + 2} columns.
\itemize{
    \item \code{read_id} : read identifier from fasta header
    \item \code{CB} : read was assigned to this CB cluster index
    \item \code{CB.n} : read to cluster CB.n distance
}
}
\description{
This function performs composition based binning on metagenomic samples,
directly from FASTA or FASTQ files, by short kmer analysis (k<8).
See \doi{10.1186/s12859-016-1186-3} for more details.
}
\examples{
composition_based_binning(
    system.file("extdata", "reads.metagenome.fasta.gz",package = "metabinR"),
    dryRun = TRUE, kMerSizeCB = 2
)
}
\references{
\url{https://github.com/gkanogiannis/metabinR}
}
\author{
Anestis Gkanogiannis, \email{anestis@gkanogiannis.com}
}
