% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcScores.R
\name{scorePairs}
\alias{scorePairs}
\title{Calculate Pairwise Alignment Scores}
\usage{
scorePairs(A, B, C, mzdiff, rtdiff, qdiff, rtrange, adductdiff)
}
\arguments{
\item{A}{Numeric weight for penalizing m/z differences.}

\item{B}{Numeric weight for penalizing differences between fitted & observed
retention times.}

\item{C}{Numeric weight for differences in Q (abundance quantiles).}

\item{mzdiff}{Numeric differences between feature m/z values}

\item{rtdiff}{Differences between model-projected retention time value &
observed retention time}

\item{qdiff}{Difference between feature quantile Q values}

\item{rtrange}{Range of dataset Y retention times}

\item{adductdiff}{Numeric divisors of computed score when non-empty adduct
labels do not match}
}
\value{
Numeric similarity score between 0 & 1
}
\description{
Helper function for \code{\link{calcScores}} &
\code{\link{evaluateParams}}. Calculates a pairwise similarity score between
grouped features using differences in m/z, rt, and Q.
}
\details{
The score between two grouped features x & y is calculated as:

\deqn{S = -exp(-A |mzx - mzy| - B |rty - rtproj|/rtrange - C |Qx - Qy|)}

where \code{mzx} & \code{Qx} correspond to the m/z and abundance quantile
values of feature x; \code{mzy}, \code{rty}, and \code{Qy} correspond to the
m/z, retention time, and quantile values of feature y; \code{rtproj}
is the model-projected retention time of feature x onto the Y dataset
chromatogram and \code{rtrange} is the retention time range of the Y dataset
chromatogram. \code{A}, \code{B}, \code{C} are non-negative constant weight
parameters for penalizing m/z, rt, and Q  differences. Values between 0 (no
confidence alignment) and 1 (high confidence alignment).
}
