% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateParams.R
\name{objective}
\alias{objective}
\title{Weight Parameter Objective Function}
\usage{
objective(
  cTable,
  idtable,
  A,
  B,
  C,
  minScore,
  mzdiff,
  rtdiff,
  qdiff,
  rtrange,
  adductdiff,
  penalty,
  matches,
  mismatches
)
}
\arguments{
\item{cTable}{data frame. Abridged \code{metabCombiner} report table.}

\item{idtable}{data frame containing all evaluated identities}

\item{A}{Numeric weight for penalizing m/z differences.}

\item{B}{Numeric weight for penalizing differences between fitted &
observed retention times}

\item{C}{Numeric weight for differences in Q (abundance quantiles).}

\item{minScore}{numeric. Minimum score to count towards objective value.}

\item{mzdiff}{numeric differences between feature m/z values}

\item{rtdiff}{Differences between model-projected retention time value &
observed retention time}

\item{qdiff}{Difference between feature quantile Q values.}

\item{rtrange}{range of dataset Y retention times}

\item{adductdiff}{Numeric divisors of computed score when non-empty adduct
labels do not match}

\item{penalty}{positive numeric penalty wherever S(i,j) > S(i,i), i =/= j}

\item{matches}{integer row indices of identity matches}

\item{mismatches}{list of integer identity row mismatches for each identity}
}
\value{
A numeric value quantifying total separability of compound match similarity
scores from mismatch scores, given A,B,C values
}
\description{
This function evaluates the A, B, C weight parameters in terms of score
separability of matching versus mismatching compound alignments. Higher
objective function value imply a superior weight parameter selection.
}
\details{
First, the similarity scores between all grouped features are calculated as
described in \code{scorePairs}

Then, the objective value for a similarity S is evaluated as:

\deqn{OBJ(S) = \sum h(S(i,i)) - h(S(i, j)) - p(S(i,i) > S(i,j))}

-S(i,i) represents the similarity between correct identity alignments \cr
-S(i,j), represents the maximum similarity of i to grouped feature j,
        i =/= j (the highest-scoring misalignment) \cr
-h(x) = x if x > \code{minScore}, 0 otherwise \cr
-p(COND) = 0 if the condition is true, and a \code{penalty} value otherwise

This is summed over all labeled compound identities (e.g. idx = idy) shared
between input datasets.
}
