% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-featdata.R
\name{mzData}
\alias{mzData}
\alias{mzData,metabCombiner-method}
\title{Retrieve m/z Values}
\usage{
mzData(object, data = NULL, value = c("obs", "mean"))

\S4method{mzData}{metabCombiner}(object, data = NULL, value = c("observed", "mean"))
}
\arguments{
\item{object}{\code{metabCombiner} object}

\item{data}{dataset identifier to extract information from; if NULL,
extracts data frame information from all datasets}

\item{value}{Either "obs" (observed - default option) or "mean" value}
}
\value{
data frame of m/z values (if NULL) or single vector of m/z values

data(plasma30)
data(plasma20)

p30 <- metabData(head(plasma30,500), samples = "CHEAR")
p20 <- metabData(head(plasma20,500), samples = "Red")
p.comb <- metabCombiner(p30, p20, xid = "p30", yid = "p20")

##retrieve all m/z
mzd <- mzData(p.comb, data = NULL)

##retrieve m/z from p30
mzd <- mzData(p.comb, data = "p30")

##retrieve mean m/z
mzd <- mzData(p.comb, value = "mean")
}
\description{
This retrieves feature m/z values from one or all constituent
datasets of a \code{metabCombiner} object. Alternatively, the average
m/z value can be retrieved.
}
