% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{calcScoresParam}
\alias{calcScoresParam}
\title{List calcScores Defaults}
\usage{
calcScoresParam(
  A = 75,
  B = 10,
  C = 0.25,
  fit = "gam",
  groups = NULL,
  usePPM = FALSE,
  useAdduct = FALSE,
  adduct = 1.25,
  brackets_ignore = c("(", "[", "{")
)
}
\arguments{
\item{A}{m/z difference specific weight; default: 75}

\item{B}{RT prediction error specific weight; default: 10}

\item{C}{Q difference specific weight; default: 0.25}

\item{fit}{choice of fitted model ("gam" or "loess"); default: "gam"}

\item{groups}{choice of m/z groups to score}

\item{usePPM}{choice to use PPM for m/z differences; default: FALSE}

\item{useAdduct}{choice to use adduct strings in scoring; default: FALSE}

\item{adduct}{value divisor for mismatched adduct strings; default: 1.25}

\item{brackets_ignore}{bracket types for ignoring string comparisons}
}
\value{
list of calcScores parameters
}
\description{
List of default parameters for score calculation step of main package
workflow. See help(calcScores) or ?calcScores for details.
}
\examples{
cs_param <- calcScoresParam(A = 60, B = 15, C = 0.3)

cs_param <- calcScoresParam(A = 0.1, B = 20, C = 0.2, usePPM = TRUE)

}
\seealso{
\code{\link{calcScores}}, \code{\link{metabCombine}}
}
