% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustData.R
\name{adjustData}
\alias{adjustData}
\title{Process and Filter Metabolomics Feature Lists}
\usage{
adjustData(Data, misspc, measure, rtmin, rtmax, zero, duplicate)
}
\arguments{
\item{Data}{a metabData object.}

\item{misspc}{Numeric. Threshold missingness percentage for analysis.}

\item{measure}{Character. Choice of central abundance measure; either
"median" or "mean".}

\item{rtmin}{Numeric. Minimum retention time for analysis.}

\item{rtmax}{Numeric. Maximum retention time for analysis.}

\item{zero}{Logical. Whether to consider zero values as missing.}

\item{duplicate}{Ordered numeric pair (m/z, rt) tolerance parameters for
duplicate feature search.}
}
\value{
Updated \code{metabData} object. The \code{data} field is processed by the
listed steps and \code{stats} list updated to contain feature statistics.
}
\description{
\code{adjustData} contains a set of pre-analysis steps for processing LC-MS
metabolomics feature tables individually
}
\details{
The pre-analysis adjustment steps include:
1) Restriction to a feature retention time range \code{rtmin} \eqn{\le}
   rt \eqn{\le} \code{rtmax}
2) Removal of features with missingness percentage exceeding \code{misspc}
3) Removal of duplicate metabolomics features.

After processing, abundance quantile (Q) values are calculated between 0 & 1
for the remaining features, as ranked by the \code{measure} argument, unless
provided by the user.
}
\seealso{
\code{\link{metabData}}, \code{\link{filterRT}}
}
