#' @title 30 minute LC-MS Analysis of Human Plasma
#'
#' @description An example metabolomics analysis of human plasma from
#' Red Cross and CHEAR cohorts, plus pooled aliquots and blanks, acquired with
#' a 30 minute total Reversed-Phase Liquid Chromatography and a QTOF-MS
#' instrument in the positive ionization mode.
#'
#' @format A data frame with 8286 rows and 22 columns
#'
#' @usage data(plasma30)
"plasma30"


#' @title 20 minute LC-MS Analysis of Human Plasma
#'
#' @description An example metabolomics analysis of human plasma from
#' Red Cross and CHEAR cohorts, plus pooled aliquots and blanks, acquired
#' with a 20 minute total Reversed-Phase Liquid Chromatography &
#' QTOF-MS instrument in the positive ionization mode.
#'
#' @format A data frame with 8910 rows and 22 columns.
#'
#' @usage data(plasma20)
"plasma20"

#' @title Three LC-MS Metabolomics Batch Datasets
#'
#' @description An example multi-batch LC-MS metabolomics analysis of human
#' plasma, used to demonstrate \code{\link{batchCombine}}. Due to the large size
#' of the full experimental data, only three of the batches are loaded here with
#' a subset of the samples and features from each batch.
#'
#' @format A list containing three identically formatted data frames
#'
#' @usage data(metabBatches)
"metabBatches"



