% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneSim.R
\name{geneSim}
\alias{geneSim}
\title{geneSim}
\usage{
geneSim(geneID1, geneID2 = NULL, measure = "Wang", combine = "BMA", semData)
}
\arguments{
\item{geneID1}{gene ID vector}

\item{geneID2}{gene ID vector}

\item{measure}{one of "Wang", "Resnik", "Rel", "Jiang" and "Lin"}

\item{combine}{One of "max", "avg", "rcmax", "BMA" methods, for combining semantic similarity scores of multiple DO terms associated with gene/protein.}

\item{semData}{gene annotation data for semantic measurement}
}
\value{
score matrix
}
\description{
semantic similarity between two gene vector
}
\examples{
## library(meshes)
## library(AnnotationHub)
## ah <- AnnotationHub()
## qr_hsa <- query(ah, c("MeSHDb", "Homo sapiens"))
## filepath_hsa <- qr_hsa[[1]]
## db <- MeSHDbi::MeSHDb(filepath_hsa)
## hsamd <- meshdata(db, category='A', computeIC=T, database="gendoo")
data(hsamd)
geneSim("241", "251", semData=hsamd, measure="Wang", combine="BMA")
}
\author{
Guangchuang Yu
}
