% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ame_methods.R
\name{ame_compare_heatmap_methods}
\alias{ame_compare_heatmap_methods}
\title{Compare AME heatmap methods}
\usage{
ame_compare_heatmap_methods(ame, group, value = -log10(adj.pvalue))
}
\arguments{
\item{ame}{ame results data.frame}

\item{group}{optional name of group to split results by}

\item{value}{value to compare to "normalize" method (default:
-log10(adj.pvalue))}
}
\value{
a cowplot 2 panel plot comparing the distribution of `value` to
  normalized rank values
}
\description{
This helper function allows the user to visualize the distribution of their
AME results data on different scales to help understand the implications of
using different values in `plot_ame_heatmap()`
}
\examples{
data("example_ame", package = "memes")
ame_compare_heatmap_methods(example_ame$Decreasing)

ame_compare_heatmap_methods(dplyr::bind_rows(example_ame, .id = "type"), type)
}
