% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mini_batch}
\alias{mini_batch}
\title{Mini_batch}
\usage{
mini_batch(
  data,
  clusters,
  batch_size,
  max_iters,
  num_init = 1L,
  init_fraction = 1,
  initializer = "kmeans++",
  compute_labels = TRUE,
  calc_wcss = FALSE,
  early_stop_iter = 10L,
  verbose = FALSE,
  CENTROIDS = NULL,
  tol = 1e-04
)
}
\arguments{
\item{data}{numeric or integer matrix-like object.}

\item{clusters}{the number of clusters.}

\item{batch_size}{the size of the mini batches.}

\item{max_iters}{the maximum number of clustering iterations.}

\item{num_init}{number of times the algorithm will be run with different
centroid seeds.}

\item{init_fraction}{percentage of data to use for the initialization
centroids (applies if initializer is \emph{kmeans++} ). Should be a float
number between 0.0 and 1.0.}

\item{initializer}{the method of initialization. One of \emph{kmeans++} and
\emph{random}. See details for more information.}

\item{compute_labels}{logical indicating whether to compute the final cluster
labels.}

\item{calc_wcss}{logical indicating whether the within-cluster sum of squares
should be computed and returned (ignored if `compute_labels = FALSE`).}

\item{early_stop_iter}{continue that many iterations after calculation of the
best within-cluster-sum-of-squared-error.}

\item{verbose}{logical indicating whether progress is printed on screen.}

\item{CENTROIDS}{an optional matrix of initial cluster centroids. The rows of
the CENTROIDS matrix should be equal to the number of clusters and the
columns should be equal to the columns of the data.}

\item{tol}{convergence tolerance.}
}
\value{
a list with the following attributes:

centroids: the final centroids;

WCSS_per_cluster (optional): the final per-cluster WCSS.

best_initialization: which initialization value led to the best WCSS
solution;

iters_per_initialization: number of iterations per each initialization;

Clusters (optional): the final cluster labels.
}
\description{
Mini-batch-k-means for matrix-like objects
}
\details{
This function performs k-means clustering using mini batches. It was
inspired by the implementation in https://github.com/mlampros/ClusterR.

The input matrix can be in any format supported by the `DelayedArray` /
`beachmat` framework, including the matrix classes defined in the `Matrix`
package and the `HDFMatrix` class.

There are two possible initializations.

\strong{kmeans++}: kmeans++ initialization.

\strong{random}: random selection of data rows as initial centroids.
}
\examples{
data = matrix(1:30,nrow = 10)
mini_batch(data, 2, 10, 10)

}
\references{
Sculley, D., 2010, April. Web-scale k-means clustering. In
Proceedings of the 19th international conference on World wide web (pp.
1177-1178). ACM.

Arthur, D. and Vassilvitskii, S., 2007, January. k-means++: The advantages of
careful seeding. In Proceedings of the eighteenth annual ACM-SIAM symposium
on Discrete algorithms (pp. 1027-1035). Society for Industrial and Applied
Mathematics.
}
