% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Linear_regression.R
\name{qqPlotLm}
\alias{qqPlotLm}
\title{qqPlotLm creates QQ-Plot of all SNPs with all taxa Linear regression analysis
This function creates QQ-Plot object of all SNPs with all taxa Linear regression analysis of
expected versus observed P values}
\usage{
qqPlotLm(microbeAbund, SnpFile, Covariate = NULL)
}
\arguments{
\item{microbeAbund}{the taxa abundance dataframe (rownames sample names and colnames taxa Genus/species/family)}

\item{SnpFile}{the snp dataframe (values 0,1,2 indicating zygosity), rownames sample names and colnames snp names.}

\item{Covariate}{default is NULL, hence assumed non-existent. If covariates are available they need to be formatted
in the CovFile format, that is colnames are sample numbers matching samples in the microbe abundance and snp file
and row names are the covariates names (such as sex, disease etc).}
}
\value{
A QQplot object of expected versus obsesrved taxa and SNP Linear Regression analysis
}
\description{
qqPlotLm creates QQ-Plot of all SNPs with all taxa Linear regression analysis
This function creates QQ-Plot object of all SNPs with all taxa Linear regression analysis of
expected versus observed P values
}
\examples{
data(microbeAbund)
data(SnpFile)
data(CovFile)
x <- qqPlotLm(microbeAbund, SnpFile, Covariate = CovFile)

}
\keyword{linear_regression}
\keyword{plot}
\keyword{snp}
\keyword{taxa}
