% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_markers.R
\name{merge_markers}
\alias{merge_markers}
\title{Merge markers list into one.}
\usage{
merge_markers(...)
}
\arguments{
\item{...}{GeneSet or GeneSetCollection object to be merged}
}
\value{
A GeneSet class of union genes in the given list
}
\description{
Merge markers collected from different DB into one 'GeneSet' object, saved a
data.frame in json format under \code{longDescription} with 'TRUE' and '-' to
indicate which DB each gene is from, this can be shown via
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}}.
}
\examples{
data("msigdb_gobp_nk")
Markers <- merge_markers(msigdb_gobp_nk[1:3])
jsonlite::fromJSON(GSEABase::longDescription(Markers))
}
