 \name{massi_select}
\alias{massi_select}

\title{
massi_select
}
\description{
This function selects the y chromosome probe data for each sample.
}
\usage{
massi_select(expression_data, y_probes, threshold = 3)
}

\arguments{
  \item{expression_data}{
The expression.data item contains normalized array expression data for all samples. This can be a data.frame with sample names as columns and probe id's as row names. This argument also allows the specification of an ExpressionSet object. 
}
  \item{y_probes}{
A data.frame of probe id's in one column that match y chromosome genes for the array platform. massiR includes probes for several Illumina and Affymetrix platforms. Details on using these probes are included in the vignette and the \code{\link{y.probes}} manual.
}
  \item{threshold}{
The threshold value corresponds to probe variation quantiles.
This option allows the selection of the most variable probes. Deciding on a probe threshold value should be informed by viewing the plot generated by the \code{\link{massi_y_plot}} function.
Threshold must be an integer "1", "2", "3", or "4". A threshold of "1" will select all y chromosome probes matching the id's in y.probes, Thresholds of "2", "3" and "4" will select probes with a CV in the top 75\%, 50\% and 25\% respectively. The aim here is to remove probes with little to no variance across the samples. Default = 3. 
}

}

\value{
A data.frame containing the subset of y chromosome probe values for each sample.
}
\author{
Sam Buckberry
}

\seealso{
\code{\link{massi_y}, \link{massi_cluster}, \link{massi_y_plot}, \link{massi_dip}, \link{massi_cluster_plot}}
}

\examples{

data(massi.test.dataset, massi.test.probes)

massi_select(expression_data=massi.test.dataset, y_probes=massi.test.probes)

}
